% ==================================================================
% JISAS Journal LaTeX Class
% ==================================================================

\ProvidesClass{jisas}[2025/01/01 JISAS Journal Template]

\LoadClass[a4paper,11pt]{article}
\usepackage{ragged2e} 

% =========================================================
% JOURNAL METADATA VARIABLES (controlled from main.tex)
% =========================================================
\newcommand{\JournalYear}{}
\newcommand{\JournalVolume}{}
\newcommand{\JournalIssue}{}
\newcommand{\JournalPages}{}
\newcommand{\JournalDOI}{}

\newcommand{\SetReceived}[1]{\def\ReceivedDate{#1}}
\newcommand{\SetRevised}[1]{\def\RevisedDate{#1}}
\newcommand{\SetAccepted}[1]{\def\AcceptedDate{#1}}

\newcommand{\SetJournalYear}[1]{\renewcommand{\JournalYear}{#1}}
\newcommand{\SetJournalVolume}[1]{\renewcommand{\JournalVolume}{#1}}
\newcommand{\SetJournalIssue}[1]{\renewcommand{\JournalIssue}{#1}}
\newcommand{\SetJournalPages}[1]{\renewcommand{\JournalPages}{#1}}
\newcommand{\SetJournalDOI}[1]{\renewcommand{\JournalDOI}{#1}}

% =========================================================
% AUTHOR / TITLE METADATA STORAGE
% =========================================================
\newcommand{\PaperTitle}{}
\newcommand{\Authors}{}
\newcommand{\Affiliations}{}
\newcommand{\Emails}{}
\newcommand{\Corresponding}{}

\newcommand{\SetTitle}[1]{\renewcommand{\PaperTitle}{#1}}
\newcommand{\SetAuthors}[1]{\renewcommand{\Authors}{#1}}
\newcommand{\SetAffiliations}[1]{\renewcommand{\Affiliations}{#1}}
\newcommand{\SetEmails}[1]{\renewcommand{\Emails}{#1}}
\newcommand{\SetCorresponding}[1]{\renewcommand{\Corresponding}{#1}}

% =========================================================
% FONT CONFIGURATION
% =========================================================
\usepackage{newtxtext,newtxmath}
\usepackage{helvet}
\newcommand{\HeaderFont}{\fontfamily{phv}\selectfont}

% =========================================================
% PAGE GEOMETRY
% =========================================================
\usepackage{geometry}
\geometry{
  top=.90in,
  bottom=1in,
  left=1in,
  right=1in,
  headheight=14pt,
  headsep=6pt
}

% =========================================================
% COLORS
% =========================================================
\usepackage[dvipsnames]{xcolor}
\definecolor{HeaderBlue}{RGB}{23,98,140}

% =========================================================
% PARAGRAPH SETTINGS
% =========================================================
\usepackage{setspace}
\setstretch{1.0}
\linespread{0.96}

\setlength{\parindent}{0pt}
\setlength{\parskip}{6pt}

% Remove left indentation for bullet lists
\usepackage{enumitem}
\setlist[itemize]{leftmargin=*}
\setlist[enumerate]{leftmargin=*}

% =========================================================
% SECTION HEADINGS
% =========================================================
\usepackage{titlesec}
\titleformat{\section}{\fontsize{14}{16}\bfseries}{\thesection}{0.5em}{}
\titleformat{\subsection}{\fontsize{12}{14}\bfseries}{\thesubsection}{0.5em}{}

% =========================================================
% GRAPHICS + FLOAT
% =========================================================
\usepackage{graphicx}
\usepackage{float}
\usepackage{booktabs}

% =========================================================
% HYPERLINK STYLE
% =========================================================
\usepackage{hyperref}
\hypersetup{
  colorlinks=true,
  urlcolor=HeaderBlue,
  linkcolor=black,
  citecolor=black
}

% =========================================================
% AUTO JOURNAL HEADER (updated to match screenshot)
% =========================================================
\newcommand{\makejournalheader}{
    \noindent
    \begin{minipage}[t]{0.40\textwidth}
 
        {\HeaderFont\fontsize{10}{12}\bfseries\color{HeaderBlue} Research Article}\\[1pt]
        {\HeaderFont\fontsize{8}{8}\color{HeaderBlue}
            \JournalYear, Vol. \JournalVolume, Issue. \JournalIssue, \JournalPages}\\[1pt]
        {\HeaderFont\fontsize{8}{8}\color{HeaderBlue}
            https://doi.org/\JournalDOI}
    \end{minipage}%
    \hfill
    \begin{minipage}[t]{0.55\textwidth}
        \raggedleft
        {\HeaderFont\color{HeaderBlue}
            \fontsize{16}{30}\selectfont\bfseries
            Journal of Innovations in\\[6pt]
            Social and Applied Sciences}
    \end{minipage}

    \vspace{8pt}
    {\color{HeaderBlue}\rule{\textwidth}{1pt}}
}

% =========================================================
% AUTO TITLE + AUTHOR BLOCK
% =========================================================
\newcommand{\makepapertitle}{
    \begin{center}
        {\Large \bfseries \PaperTitle}\\[10pt]

        {\Authors}\\[6pt]

        {\footnotesize \Affiliations}\\[3pt]

        {\footnotesize \textit{\Emails}}\\
        {\footnotesize \textbf{Corresponding Author:} \textit{\Corresponding}}
    \end{center}

    \vspace{0.5cm}
}

% =========================================================
% FOOTER CONFIGURATION — FIRST PAGE vs OTHER PAGES
% =========================================================
\usepackage{fancyhdr}

% ---------- FIRST PAGE FOOTER ----------
\fancypagestyle{firstpage}{
    \fancyhf{}
    \fancyfoot[L]{\fontsize{8}{9}\selectfont Vol. \JournalVolume, Issue \JournalIssue}
    \fancyfoot[C]{%
      \parbox[t]{0.75\textwidth}{\centering
      \fontsize{8}{9}\selectfont
      © \JournalYear\ The Authors. Published by the Journal of Innovations in Social and Applied Sciences.\\
      Licensed under the Creative Commons Attribution (CC BY 4.0) License.}
    }
    \fancyfoot[R]{\fontsize{8}{9}\selectfont \thepage}

    % ======= FOOTER BORDER LINE =======
    \renewcommand{\footrulewidth}{0.3pt}
    \renewcommand{\footrule}{\hbox to\headwidth{\color{gray}\leaders\hrule height \footrulewidth\hfill}}
    % ==================================

    \renewcommand{\headrulewidth}{0pt}
}

% ---------- ALL OTHER PAGES ----------
\pagestyle{fancy}
\fancyhf{}
\fancyfoot[L]{\fontsize{8}{9}\selectfont Vol. \JournalVolume, Issue \JournalIssue}
\fancyfoot[R]{\fontsize{8}{9}\selectfont \thepage}

% ======= FOOTER BORDER LINE =======
\renewcommand{\footrulewidth}{0.3pt}
\renewcommand{\footrule}{\hbox to\headwidth{\color{gray}\leaders\hrule height \footrulewidth\hfill}}
% ==================================

\renewcommand{\headrulewidth}{0pt}

% =========================================================
% START PAGE NUMBER FROM 249
% =========================================================
\AtBeginDocument{%
  \setcounter{page}{249}
}
