JISAS LaTeX Template — README

   Journal of Innovations in Social and Applied Sciences (JISAS)

Official LaTeX Template (2025 Edition)
This repository provides the complete LaTeX template for preparing manuscripts for the Journal of Innovations in Social and Applied Sciences (JISAS). Authors can use this template to prepare submissions in a clean, consistent, and professionally formatted layout.



 Repository Contents


/jisas-template/
│
├── jisas.cls               → Main class file containing formatting rules
├── main.tex                → Example manuscript file
├── img/
│   └── jisas-logo.png      → Journal logo (if used)
├── README.md               → Instructions for authors
└── references.bib          → Optional BibTeX file (if using BibTeX)




 How to Use This Template

1. Create a New Overleaf Project

You can use one of the following options:

 Upload this entire folder to Overleaf
  or
 Create a new Blank Project → Upload `jisas.cls`, `main.tex`, and the `img/` folder.



✏️ 2. Start Writing in `main.tex`

The template separates metadata from the main content.
Set your paper information using these commands:

latex
\SetTitle{Your Paper Title}
\SetAuthors{Author 1, Author 2}
\SetAffiliations{Affiliation(s)}
\SetEmails{email1@example.com; email2@example.com}
\SetCorresponding{corresponding@example.com}

\SetJournalYear{2025}
\SetJournalVolume{62}
\SetJournalIssue{2}
\SetJournalPages{xx--yy}
\SetJournalDOI{10.xxxx/xxxxx}

\SetReceived{January 10, 2025}
\SetRevised{February 15, 2025}
\SetAccepted{March 2, 2025}


The template will automatically generate the:

✔ Header
✔ Title block
✔ Author block
✔ Footer
✔ Page numbers starting from the configured value



 3. Sections and Subsections

Numbering Rules

 Introduction, Literature Review, Methods, Results, Conclusion, References → Automatically numbered.
 Abstract and Keywords → Not numbered.
 Subsections → Numbered as 3.1, 3.2, 3.3, etc.
 Subsubsections → Not numbered (bold only).

Example

latex
\section{Introduction}

\section{Literature Review}

\section{Methodology}
\subsection{Data Collection}
\subsection{Model Architecture}

\section{Experimental Results}
\subsection{Dataset}
\subsection{Evaluation Metrics}

\section{Conclusion}




 4. Figures, Tables, and Equations

Figure Example

latex
\begin{figure}[H]
\centering
\includegraphics[width=0.75\linewidth]{img/figure1.png}
\caption{Sample figure caption.}
\label{fig:example}
\end{figure}


Cite using:
`As shown in Figure~\ref{fig:example} ...`

Table Example

latex
\begin{table}[H]
\centering
\caption{Sample table caption (placed above the table).}
\begin{tabular}{l c c}
\toprule
Method & Accuracy & F1-score \\
\midrule
Model A & 92.1 & 88.4 \\
Model B & 94.3 & 90.7 \\
\bottomrule
\end{tabular}
\label{tab:results}
\end{table}


Cite using:
`See Table~\ref{tab:results}.`



Equation Example

latex
\begin{equation}
y = \alpha x^2 + \beta x + c
\label{eq:poly}
\end{equation}


Cite using:
`Equation~\ref{eq:poly}`



 5. Keywords Format

Write them in a single line separated by semicolons:


Keywords: keyword one; keyword two; keyword three; keyword four; keyword five




 6. Page Numbering

The template starts numbering at a specific page automatically:

latex
\AtBeginDocument{
  \setcounter{page}{249}
}


To change the starting page, modify `249` to any desired number.



7. Copyright

The footer includes automatic open-access licensing:


© YYYY The Authors. Published by the Journal of Innovations in Social and Applied Sciences.
Licensed under the Creative Commons Attribution (CC BY 4.0) License.




 8. Questions or Support

For help using this template, please contact the journal editorial office.

